/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.ar;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.pa.util.GenericNonValidatingParser;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.TimeProblemFilter;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.p.pa.event.RioDomainAnalysisEvent;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.xfw.pa.ar.AnalysisDomainAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.NodeList;

public class RioDomainAnalysisRoutine
extends AnalysisDomainAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPARDART";
    private static final String TRACE_MASKF = "PPARDARF";
    private static final String TRACE_MASKD = "PPARDARD";

    public RioDomainAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKT, "--> RioDomainAnalysisRoutine.analyze()");
        RioDomainAnalysisEvent ourEvent = (RioDomainAnalysisEvent)event;
        String path = null;
        boolean powerFailure = false;
        try {
            path = BaseFileControl.getFilePath("paconfig");
        }
        catch (Exception e) {
            // empty catch block
        }
        String xmlFileToUse = path + "rioRefCode.xml";
        NodeList refcodePriorities = null;
        try {
            refcodePriorities = GenericNonValidatingParser.parseXMLFileNameForTag(xmlFileToUse, "rioErrors");
            if (refcodePriorities != null) {
                Trace.trace(TRACE_MASKD, "have an RB");
            } else {
                Trace.trace(TRACE_MASKD, "do not have an RB");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Exception parsing file");
            FrameworkLog microCodeEvent = new FrameworkLog(new FrameworkClassLogInfo(92, "ParsingRioAnalysisEvent"), Short.parseShort("0"), Short.parseShort("1"), 0);
            microCodeEvent.log();
            return;
        }
        PASystem system = ourEvent.getSystem();
        String poolId = ourEvent.getIncidentPoolId();
        IncidentPool thePool = RioDomainAnalysisRoutine.getAnalyzingIncidentPool(poolId);
        if (thePool == null) {
            Trace.trace(TRACE_MASKT, "<-- analyze(): no pool to analyze");
            return;
        }
        ArrayList<CommonServiceIncident> remList = new ArrayList<CommonServiceIncident>();
        CommonServiceIncident topIncident = null;
        CommonServiceIncident anIncident = null;
        Iterator poolIterator = thePool.iterator();
        Trace.trace(TRACE_MASKD, "About to get our Top Incident thePool.size()= " + thePool.size());
        while (poolIterator.hasNext()) {
            anIncident = (CommonServiceIncident)poolIterator.next();
            String refcode = ((DistributedDataEvent)anIncident.getProblem().getPrimaryDataEvent()).getRefcode();
            float priority = RioDomainAnalysisRoutine.getRefcodePriority(refcodePriorities, refcode);
            anIncident.setPriority(priority);
            anIncident.getProblem().setRefcode(refcode);
            if (topIncident == null) {
                topIncident = anIncident;
                topIncident.setPriority(priority);
                continue;
            }
            if (priority > topIncident.getPriority()) {
                remList.add(topIncident);
                topIncident = anIncident;
                topIncident.setPriority(priority);
                continue;
            }
            remList.add(anIncident);
        }
        Trace.trace(TRACE_MASKD, "auxiallary list remList.size()= " + remList.size());
        if (remList.size() != 0) {
            boolean swapIndex = false;
            CommonProblem topProblem = topIncident.getProblem();
            Iterator rlI = remList.iterator();
            while (rlI.hasNext()) {
                CommonServiceIncident associateIncident = (CommonServiceIncident)rlI.next();
                topProblem.addSecondaryDataEvent(associateIncident.getProblem().getPrimaryDataEvent());
                thePool.remove(associateIncident);
            }
            Trace.trace(TRACE_MASKD, "should have removed associatin incidents from pool = " + thePool.size());
            PIFru highFru = null;
            boolean highFruPri = false;
            XMLEncodeableArrayList thisFruList = ((DistributedDataEvent)topProblem.getPrimaryDataEvent()).getFruList();
            for (int y = 0; y < thisFruList.size(); ++y) {
                PIFru thisFru = (PIFru)thisFruList.get(y);
                if (highFru == null) {
                    highFru = thisFru;
                    continue;
                }
                if (thisFru.getNumericPriority() <= highFru.getNumericPriority()) continue;
                highFru = thisFru;
            }
            if (highFru != null) {
                String highFruPowerMTMS = null;
                if (highFru.getPowerControllingSystem() != null) {
                    highFruPowerMTMS = highFru.getPowerControllingSystem().getMTMS();
                } else if (highFru.getEnclosureSystem() != null) {
                    highFruPowerMTMS = highFru.getEnclosureSystem().getMTMS();
                }
                if (highFruPowerMTMS != null) {
                    Set analyzingPools = RioDomainAnalysisRoutine.getAnalyzingIncidentPoolIdSet();
                    Iterator apIds = analyzingPools.iterator();
                    while (apIds.hasNext()) {
                        String analyzingPoolId = (String)apIds.next();
                        if (analyzingPoolId.indexOf(highFruPowerMTMS) != -1) continue;
                        IncidentPool fruPool = RioDomainAnalysisRoutine.getAnalyzingIncidentPool(analyzingPoolId);
                        Iterator fpi = fruPool.iterator();
                        int highOrder = -128;
                        while (fpi.hasNext()) {
                            CommonServiceIncident fruPoolIncident = (CommonServiceIncident)fpi.next();
                            byte[] refcode = HexString.toHexBytes(((DistributedDataEvent)fruPoolIncident.getProblem().getPrimaryDataEvent()).getRefcode());
                            if ((refcode[0] & highOrder) != highOrder) continue;
                            powerFailure = true;
                            Trace.trace(TRACE_MASKT, "Highest Priority fru had a power failure");
                        }
                    }
                }
                if (!powerFailure) {
                    Trace.trace(TRACE_MASKD, "HighFru did not exist in the analyzing pools look at recent problems");
                    powerFailure = this.checkRecentProblems(highFruPowerMTMS);
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "no associates in the pool");
        }
        Trace.trace(TRACE_MASKD, "post a SystemAnalysisCompleteEvent");
        if (!powerFailure) {
            this.postServiceAREvent(new CommonServiceAREvent(this), system, poolId);
        }
        Trace.trace(TRACE_MASKD, "<-- RioDomainAnalyze()");
    }

    public static float getRefcodePriority(NodeList refcodePriorities, String refcode) {
        float priority = 0.0f;
        for (int i = 0; i < refcodePriorities.getLength(); ++i) {
            if (!refcodePriorities.item(i).getNodeName().equals("problem")) continue;
            try {
                if (!Pattern.matches(refcode, XMLHelper.getAttributeValue(refcodePriorities.item(i), "refcode"))) continue;
                return Float.parseFloat(XMLHelper.getAttributeValue(refcodePriorities.item(i), "priority"));
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "Error using regular expressions " + e);
            }
        }
        return priority;
    }

    private boolean checkRecentProblems(String highFruPowerMTMS) {
        ArrayList timeFilteredProblems = new ArrayList();
        List knownProblems = null;
        try {
            knownProblems = ProblemManager.getProblemManager().getAllProblems();
        }
        catch (PersistenceNotInitializedException e1) {
            e1.printStackTrace();
        }
        catch (ProblemPersistenceException e1) {
            e1.printStackTrace();
        }
        TimeProblemFilter timeFilter = new TimeProblemFilter(300000L);
        timeFilteredProblems.clear();
        if (knownProblems != null) {
            timeFilter.filter(timeFilteredProblems, knownProblems);
        }
        for (int i = 0; i < timeFilteredProblems.size(); ++i) {
            if (!((CommonProblem)timeFilteredProblems.get(i)).getReportingRemoteMachineSystem().getMTMS().equals(highFruPowerMTMS)) continue;
            Trace.trace(TRACE_MASKD, "recent problem indicate a power failure");
            return true;
        }
        return false;
    }
}

